<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Facility extends Model 
{

    protected $table = 'facilities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('owner_id', 'manager_owner_id', 'name', 'timezone', 'state', 'country', 'service_level', 'category', 'facility_type', 'legacy_id', 'import_id', 'source', 'import_version', 'permissions', 'facility_role');

    public function facilityClasses()
    {
        return $this->hasMany('App\Models\Facility')->withPivot('FacilityFacilityClass');
    }

    public function facilityFacilityClasses()
    {
        return $this->hasMany('App\Models\FacilityFacilityClasses');
    }

    public function users()
    {
        return $this->hasMany('App\Models\UserFacility');
    }

    public function consultants()
    {
        return $this->hasMany('App\Models\UserFacility')->where(user.user_type, staff);
    }

    public function clients()
    {
        return $this->hasMany('App\Models\UserFacility')->where(user.user_type, client);
    }

    public function owner()
    {
        return $this->belongsTo('App\Models\Owner');
    }

    public function ownerManager()
    {
        return $this->belongsTo('App\Models\Owner');
    }

    public function departments()
    {
        return $this->hasMany('App/Models\Department');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

}